#ifndef _IGEOMETRY_H
#define _IGEOMETRY_H

#include <buildspec.h>
#include <ostream>
#include <vector>

#include <Geometry/SimplexProperty.h>
#include <Utils/Color.h>
#include <boost/shared_ptr.hpp>

#include <GSTenums.h>

namespace GST
{
namespace Geometry
{

class GST_API_EXPORT IGeometry
{
public:
	struct GeoPoint
	{
		double x, y, z;
	};

	typedef GeometryTypes GeometryType;
	typedef RequestFormats RequestFormat;
	/**0 .. 1 <=> off .. on*/
	typedef Utils::ColorCoding ColorCode;
	/**0 .. 1 <=> solid .. glas*/
	typedef Utils::TransparencyCoding TransparencyCode;
	struct Color
	{
		ColorCode r, g, b;
		Color() : r(-1.0), g(-1.0), b(-1.0)
		{
		}
		Color(ColorCode _r, ColorCode _g, ColorCode _b) : r(_r), g(_g), b(_b)
		{
		}
	};

	// public IGeometry Interface
	virtual const GeometryType &getType() const
	{
		return _type;
	}
	virtual void setType(const GeometryType &type)
	{
		_type = type;
	}
	IGeometry(const IGeometry &geo)
	{
	}
	virtual ~IGeometry()
	{
	}

	// object properties to be implemented in sub classes
	virtual void setName(const std::string &name)
	{
	}
	virtual std::string getName() const
	{
		return std::string();
	}
	virtual Color GetColor() const
	{
		return Color();
	}
	virtual TransparencyCode GetTransparency() const
	{
		return TransparencyCode();
	}

	virtual void writeAsWKTAt(std::ostream &os) const
	{
	}
	virtual void writeAsGMLAt(std::ostream &os) const
	{
	}
	virtual void writePropertiesAt(std::ostream &os) const
	{
	}

	virtual size_t getNumberVertices() const
	{
		return 0;
	}

	// virtual std::vector<PropertyItem*>& getProperties() { return new
	// std::vector<PropertyItem*>(); }

	// property parsing actions
	// virtual unsigned int addProperty(const std::string & name, const
	// PropertyItem::PropertyType & type, const unsigned int& dim) { return 0; }
	/*	virtual void addValue(SimplexProperty* toItem, const std::string& value)
	   {} virtual void addVector(SimplexProperty* toItem, const
	   std::vector<std::string>& vector) {} virtual SimplexProperty*
	   createSimplexProperty(const std::string & name, const
	   SimplexProperty::PropertyType & PropertyType, const unsigned int & dims)
	   { return NULL; }
	*/
	// geometry parsing actions
	virtual void addPoint(const double &x, const double &y, const double &z)
	{
	}
	virtual void newPart()
	{
	}
	virtual void addTriangle(const unsigned int &i1,
							 const unsigned int &i2,
							 const unsigned int &i3)
	{
	}
	virtual void addTetrahedron(const unsigned int &i1,
								const unsigned int &i2,
								const unsigned int &i3,
								const unsigned int &i4)
	{
	}

	///@name boost container members
	//@{
	/**
	 * Implement this method in derived class creating a cloned
	 * but new instance!
	 * (This is need due to the use of this abstract in ptr_vector<>.)
	 */
	virtual IGeometry *clone() const
	{
		return NULL;
	};
	//@}

protected:
	IGeometry()
	{
	}
	IGeometry(GeometryType type) : _type(type)
	{
	}

private:
	GeometryType _type;
};

} // namespace Geometry
} // namespace GST

#endif //_IGEOMETRY_H
